/*
 * Decompiled with CFR 0.152.
 */
package org.diao.diaoCatSeedLoginGui;

import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.diao.diaoCatSeedLoginGui.adapter.AuthMeImpl;
import org.diao.diaoCatSeedLoginGui.adapter.CatSeedImpl;
import org.diao.diaoCatSeedLoginGui.adapter.LoginAdapter;
import org.diao.diaoCatSeedLoginGui.command.MainCommand;
import org.diao.diaoCatSeedLoginGui.listener.AuthMeListener;
import org.diao.diaoCatSeedLoginGui.listener.CatSeedListener;
import org.diao.diaoCatSeedLoginGui.listener.DiaoListener;
import org.diao.diaoCatSeedLoginGui.manager.ConfigManager;
import org.diao.diaoCatSeedLoginGui.manager.GuiManager;

public class Main
extends JavaPlugin {
    private static Main instance;
    private ConfigManager configManager;
    private GuiManager guiManager;
    private LoginAdapter loginAdapter;
    private boolean hasAssetApi = false;

    public static Main getInstance() {
        return instance;
    }

    public void onEnable() {
        instance = this;
        if (!this.checkCoreDependencies()) {
            return;
        }
        this.checkSoftDependencies();
        if (!this.setupLoginAdapter()) {
            this.getLogger().severe("\u672a\u68c0\u6d4b\u5230\u652f\u6301\u7684\u767b\u5f55\u63d2\u4ef6 (CatSeedLogin \u6216 AuthMe)\uff01");
            this.getLogger().severe("\u63d2\u4ef6\u5373\u5c06\u7981\u7528...");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        try {
            this.configManager = new ConfigManager(this);
            this.guiManager = new GuiManager(this);
        }
        catch (Exception e) {
            this.getLogger().severe("\u63d2\u4ef6\u521d\u59cb\u5316\u5931\u8d25: " + e.getMessage());
            e.printStackTrace();
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        Bukkit.getPluginManager().registerEvents((Listener)new DiaoListener(this), (Plugin)this);
        if (this.getCommand("dcsg") != null) {
            this.getCommand("dcsg").setExecutor((CommandExecutor)new MainCommand(this));
        }
        this.printStartMessage();
    }

    public void onDisable() {
        if (this.guiManager != null) {
            this.guiManager.cleanup();
        }
        this.getLogger().info("\u5927\u8c82\u767b\u5f55\u754c\u9762 \u5df2\u5378\u8f7d\u3002");
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public GuiManager getGuiManager() {
        return this.guiManager;
    }

    public boolean isHasAssetApi() {
        return this.hasAssetApi;
    }

    public LoginAdapter getLoginAdapter() {
        return this.loginAdapter;
    }

    private boolean setupLoginAdapter() {
        if (Bukkit.getPluginManager().getPlugin("CatSeedLogin") != null) {
            this.loginAdapter = new CatSeedImpl();
            Bukkit.getPluginManager().registerEvents((Listener)new CatSeedListener(this), (Plugin)this);
            this.getLogger().info("\u68c0\u6d4b\u5230 CatSeedLogin\uff0c\u5df2\u542f\u7528\u732b\u79cd\u5b50\u6a21\u5f0f\u3002");
            return true;
        }
        if (Bukkit.getPluginManager().getPlugin("AuthMe") != null) {
            this.loginAdapter = new AuthMeImpl();
            Bukkit.getPluginManager().registerEvents((Listener)new AuthMeListener(this), (Plugin)this);
            this.getLogger().info("\u68c0\u6d4b\u5230 AuthMe\uff0c\u5df2\u542f\u7528 AuthMe \u6a21\u5f0f\u3002");
            return true;
        }
        return false;
    }

    private boolean checkCoreDependencies() {
        try {
            Class.forName("yslelf.cloudpick.bukkit.api.event.CustomPacketEvent");
            return true;
        }
        catch (ClassNotFoundException e) {
            this.getLogger().severe("\u65e0\u6cd5\u52a0\u8f7d \u4e91\u62fe (CloudPick) API\uff01\u63d2\u4ef6\u5c06\u7981\u7528\u3002");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return false;
        }
    }

    private void checkSoftDependencies() {
        Plugin plugin = Bukkit.getPluginManager().getPlugin("Cloudpicktoopcik");
        if (plugin != null && plugin.isEnabled()) {
            this.hasAssetApi = true;
            this.getLogger().info("\u5df2\u8fde\u63a5 Cloudpicktoopcik\u3002");
        } else {
            this.hasAssetApi = false;
        }
    }

    private void printStartMessage() {
        this.getLogger().info("\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
        this.getLogger().info("\u5927\u8c82\u767b\u5f55\u754c\u9762 (DiaoCatSeedLoginGui) \u52a0\u8f7d\u6210\u529f\uff01");
        this.getLogger().info("\u5f53\u524d\u6a21\u5f0f: " + this.loginAdapter.getClass().getSimpleName().replace("Impl", ""));
        this.getLogger().info("\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
    }
}

