/*
 * Decompiled with CFR 0.152.
 */
package org.diao.diaoCatSeedLoginGui.listener;

import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.diao.diaoCatSeedLoginGui.Main;
import yslelf.cloudpick.bukkit.api.PacketSender;
import yslelf.cloudpick.bukkit.api.event.CustomPacketEvent;

public class DiaoListener
implements Listener {
    private final Main plugin;

    public DiaoListener(Main plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            Player player = event.getPlayer();
            if (player.isOnline()) {
                this.plugin.getGuiManager().checkAndOpenGUI(player);
            }
        }, 40L);
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.plugin.getGuiManager().removePending(event.getPlayer());
    }

    @EventHandler
    public void onCustomPacketReceived(CustomPacketEvent event) {
        String id = event.getIdentifier();
        Player player = event.getPlayer();
        if ("zcg_login".equals(id)) {
            this.handleGuiResponse(player);
            String content = this.plugin.getConfigManager().getLoginAnnouncement();
            this.sendCustomData(player, "zcg_login_return", content);
        } else if ("zcg_register".equals(id)) {
            this.handleGuiResponse(player);
            String content = this.plugin.getConfigManager().getRegisterAnnouncement();
            this.sendCustomData(player, "zcg_register_return", content);
        } else if ("Zcg.open".equals(id)) {
            this.handleGuiResponse(player);
            try {
                List<String> pwdReqs = this.plugin.getConfigManager().getPasswordRequirements();
                PacketSender.sendCustomData((Player)player, (String)"Zcg.open_ps_return", (Object[])pwdReqs.toArray(new String[0]));
                if (this.plugin.getConfigManager().isDebugMode()) {
                    this.plugin.getLogger().info("[Debug -> " + player.getName() + "] \u5df2\u53d1\u9001\u5bc6\u7801\u8981\u6c42\u3002");
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("\u53d1\u9001\u5bc6\u7801\u8981\u6c42\u5931\u8d25: " + e.getMessage());
            }
        }
    }

    private void handleGuiResponse(Player player) {
        this.plugin.getGuiManager().removePending(player);
        if (this.plugin.getLoginAdapter().isLogin(player)) {
            this.plugin.getGuiManager().removePending(player);
        }
    }

    private void sendCustomData(Player player, String id, String data) {
        try {
            PacketSender.sendCustomData((Player)player, (String)id, (Object[])new Object[]{data});
            if (this.plugin.getConfigManager().isDebugMode()) {
                this.plugin.getLogger().info("[Debug -> " + player.getName() + "] \u53d1\u9001\u6570\u636e\u5305: " + id);
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("\u53d1\u9001\u6570\u636e\u5305\u5931\u8d25 (" + id + "): " + e.getMessage());
        }
    }
}

