/*
 * Decompiled with CFR 0.152.
 */
package org.diao.diaoCatSeedLoginGui.manager;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.FileConfiguration;
import org.diao.diaoCatSeedLoginGui.Main;

public class ConfigManager {
    private final Main plugin;
    private boolean debugMode;
    private String loginGui;
    private String registerGui;
    private String loginAnnouncement;
    private String registerAnnouncement;
    private List<String> passwordRequirements;

    public ConfigManager(Main plugin) {
        this.plugin = plugin;
        this.loadConfig();
    }

    public void loadConfig() {
        this.plugin.saveDefaultConfig();
        this.plugin.reloadConfig();
        FileConfiguration config = this.plugin.getConfig();
        this.debugMode = config.getBoolean("debug", false);
        this.loginGui = config.getString("gui.Login", "login.yml");
        this.registerGui = config.getString("gui.Register", "register.yml");
        this.loginAnnouncement = this.parseAnnouncement(config.getStringList("announcement_login"), "&c\u6682\u65e0\u767b\u5f55\u516c\u544a");
        this.registerAnnouncement = this.parseAnnouncement(config.getStringList("announcement_register"), "&c\u6682\u65e0\u6ce8\u518c\u516c\u544a");
        this.passwordRequirements = new ArrayList<String>();
        this.passwordRequirements.add(String.valueOf(config.getInt("password_requirements.min_length", 6)));
        this.passwordRequirements.add(String.valueOf(config.getInt("password_requirements.max_length", 20)));
        this.passwordRequirements.add(String.valueOf(config.getBoolean("password_requirements.require_letter", true)));
        this.passwordRequirements.add(String.valueOf(config.getBoolean("password_requirements.require_uppercase", false)));
        this.passwordRequirements.add(String.valueOf(config.getBoolean("password_requirements.require_number", true)));
        this.passwordRequirements.add(String.valueOf(config.getBoolean("password_requirements.require_special", false)));
        if (this.debugMode) {
            this.plugin.getLogger().info("Debug\u6a21\u5f0f\u5df2\u5f00\u542f");
        }
    }

    private String parseAnnouncement(List<String> rawList, String defaultText) {
        if (rawList == null || rawList.isEmpty()) {
            return defaultText;
        }
        return rawList.stream().map(line -> ChatColor.translateAlternateColorCodes((char)'&', (String)line)).collect(Collectors.joining("\n"));
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public String getLoginGui() {
        return this.loginGui;
    }

    public String getRegisterGui() {
        return this.registerGui;
    }

    public String getLoginAnnouncement() {
        return this.loginAnnouncement;
    }

    public String getRegisterAnnouncement() {
        return this.registerAnnouncement;
    }

    public List<String> getPasswordRequirements() {
        return this.passwordRequirements;
    }
}

