/*
 * Decompiled with CFR 0.152.
 */
package org.diao.diaoCatSeedLoginGui.manager;

import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.diao.cloudpicktoopcik.Cloudpicktoopcik;
import org.diao.diaoCatSeedLoginGui.Main;
import org.diao.diaoCatSeedLoginGui.adapter.LoginAdapter;
import yslelf.cloudpick.bukkit.api.PacketSender;

public class GuiManager {
    private final Main plugin;
    private final Set<UUID> pendingResponsePlayers = Collections.newSetFromMap(new ConcurrentHashMap());

    public GuiManager(Main plugin) {
        this.plugin = plugin;
    }

    public void cleanup() {
        this.pendingResponsePlayers.clear();
    }

    public void removePending(Player player) {
        if (this.pendingResponsePlayers.remove(player.getUniqueId())) {
            this.debugLog(player, "\u6536\u5230\u5ba2\u6237\u7aef\u54cd\u5e94\uff0c\u6d41\u7a0b\u7ed3\u675f (\u9501\u5df2\u91ca\u653e)\u3002");
        }
    }

    public void checkAndOpenGUI(Player player) {
        if (player == null || !player.isOnline()) {
            return;
        }
        if (this.pendingResponsePlayers.contains(player.getUniqueId())) {
            return;
        }
        LoginAdapter adapter = this.plugin.getLoginAdapter();
        String playerName = player.getName();
        if (adapter.isLogin(player)) {
            return;
        }
        boolean isResourceReady = true;
        if (this.plugin.isHasAssetApi()) {
            try {
                isResourceReady = Cloudpicktoopcik.hasSentAssets((Player)player);
            }
            catch (Throwable e) {
                isResourceReady = true;
            }
        }
        if (!isResourceReady) {
            this.debugLog(player, "\u7b49\u5f85\u8d44\u6e90\u5305\u52a0\u8f7d... (1\u79d2\u540e\u91cd\u8bd5)");
            this.pendingResponsePlayers.add(player.getUniqueId());
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                this.pendingResponsePlayers.remove(player.getUniqueId());
                if (player.isOnline()) {
                    this.checkAndOpenGUI(player);
                }
            }, 20L);
            return;
        }
        String guiType = adapter.isRegister(playerName) ? this.plugin.getConfigManager().getLoginGui() : this.plugin.getConfigManager().getRegisterGui();
        this.openGUI(player, guiType);
    }

    private void openGUI(Player player, String guiName) {
        if (guiName == null || guiName.isEmpty()) {
            return;
        }
        this.pendingResponsePlayers.add(player.getUniqueId());
        try {
            PacketSender.sendOpenGui((Player)player, (String)("interface/segment/" + guiName));
            this.debugLog(player, "\u53d1\u9001\u754c\u9762\u6253\u5f00\u8bf7\u6c42: " + guiName);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("\u6253\u5f00GUI\u5931\u8d25: " + e.getMessage());
            this.pendingResponsePlayers.remove(player.getUniqueId());
            return;
        }
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            if (this.pendingResponsePlayers.contains(player.getUniqueId()) && player.isOnline()) {
                if (this.plugin.getLoginAdapter().isLogin(player)) {
                    this.pendingResponsePlayers.remove(player.getUniqueId());
                    return;
                }
                this.debugLog(player, "\u8d85\u65f6\u672a\u54cd\u5e94\uff0c\u51c6\u5907\u91cd\u8bd5...");
                this.pendingResponsePlayers.remove(player.getUniqueId());
                this.checkAndOpenGUI(player);
            }
        }, 40L);
    }

    private void debugLog(Player player, String message) {
        if (this.plugin.getConfigManager().isDebugMode()) {
            player.sendMessage("\u00a78[Debug] \u00a7f" + message);
            this.plugin.getLogger().info("[Debug -> " + player.getName() + "] " + message);
        }
    }
}

